
function AISMN_GoToWell::OnEnter(%this, %data)
{
   // if the character cannot path to a well, go to a water tower
   %data.panic = false;
   if (SetPathForNearestTeamBuilding(%data, "Well Watertower", $OST_PLAYER, 0) == false)
   {
      %data.panic = true;
      return;
   }
   
   %object = GetThisObject(%data);
   %object.playThread(0, "run");
   %object.unmountImage(2);
   %object.mountImage("emptypail", 2);
}

function AISMN_GoToWell::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");
   
   RestoreCharacterOutfit(%data);
}

//EXIT 0: BUILDING HAS BURNED UP
//EXIT 1: BUILDING IS NOT ON FIRE
//EXIT 2: AT WELL
//EXIT 3: WELL DOES NOT EXIST.
function AISMN_GoToWell::Update(%this, %data)
{
   //If we can't path to the well, return error.
   if (%data.panic == true)
   {
      ReturnValue(%data, 2);
      return;
   }
   
   //Get the building component and target
   %tar = GetParameterTarget(%data);
   %component = slgQueryInterface(%tar, $CID_BUILDING);
   
   //If the object doesn't exist, it probably burned up.
   if (0 == %tar || 0 == %component)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   //If the object is no longer on fire, change states.
   if (%component.onFire() == false)
   {
      StopMoving(%data);
      ReturnValue(%data, 0);
      return;
   }
   
   //If we've arrived at the well, return success.
   if (!IsFollowingPath(%data))
   {
      ReturnValue(%data, 1);
      return;
   }
   
   //Stay in this state
   ReturnValue(%data, -1);
}
